//[BotStacks Chat SDK](../../index.md)/[ai.botstacks.sdk.ui.theme](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [Assets](-assets/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>data class [Assets](-assets/index.md)(val logo: [ImageAssetIdentifier](-image-asset-identifier/index.md)? = null, val emptyChat: [EmptyScreenConfig.Messages](-empty-screen-config/-messages/index.md) = EmptyScreenConfig.Messages(         caption = &quot;No messages&quot;,     ), val emptyChats: [EmptyScreenConfig.Chats](-empty-screen-config/-chats/index.md) = EmptyScreenConfig.Chats(         caption = &quot;You haven't added any chats yet&quot;,     ))<br>Assets to be utilized and customized for on-brand experience within BotStacks. |
| [Colors](-colors/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>class [Colors](-colors/index.md)(isDark: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), primary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onPrimary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), header: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onHeader: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), background: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onBackground: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), surface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onSurface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onSurfaceVariant: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), border: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), message: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onMessage: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), chatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onChatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), caption: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), success: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onSuccess: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), error: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), onError: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), ripple: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html), scrim: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html))<br>ColorScheme that drives all BotStacks Components. |
| [Dimensions](-dimensions/index.md) | [common]<br>class [Dimensions](-dimensions/index.md)(val border: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) = 1.dp, val thickBorder: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) = 2.dp, val inset: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val widthWindowSizeClass: [WindowWidthSizeClass](https://developer.android.com/reference/kotlin/androidx/compose/material3/windowsizeclass/WindowWidthSizeClass.html) = WindowWidthSizeClass.Compact, val heightWindowSizeClass: [WindowHeightSizeClass](https://developer.android.com/reference/kotlin/androidx/compose/material3/windowsizeclass/WindowHeightSizeClass.html) = WindowHeightSizeClass.Compact, val imagePreviewSize: [Size](https://developer.android.com/reference/kotlin/androidx/compose/ui/geometry/Size.html) = Size(width = 178f, height = 152f), val videoPreviewSize: [Size](https://developer.android.com/reference/kotlin/androidx/compose/ui/geometry/Size.html) = Size(width = 178f, height = 152f), val grid: [GridDimensionSet](-grid-dimension-set/index.md), val staticGrid: [GridDimensionSet](-grid-dimension-set/index.md) = staticGridPreset)<br>Dimensions that drive spacing and padding within Components |
| [EmptyScreenConfig](-empty-screen-config/index.md) | [common]<br>sealed class [EmptyScreenConfig](-empty-screen-config/index.md)(val image: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [ImageAsset](-image-asset/index.md)? = { null }, val caption: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, val type: [EmptyScreenType](-empty-screen-type/index.md))<br>Configuration for an empty state |
| [EmptyScreenType](-empty-screen-type/index.md) | [common]<br>interface [EmptyScreenType](-empty-screen-type/index.md)<br>Type determination for empty states for certain components |
| [Fonts](-fonts/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>class [Fonts](-fonts/index.md)(val h1: [FontStyle](-font-style/index.md), val h2: [FontStyle](-font-style/index.md), val h3: [FontStyle](-font-style/index.md), val body1: [FontStyle](-font-style/index.md), val body2: [FontStyle](-font-style/index.md), val label1: [FontStyle](-font-style/index.md), val label2: [FontStyle](-font-style/index.md), val button1: [FontStyle](-font-style/index.md), val button2: [FontStyle](-font-style/index.md), val caption1: [FontStyle](-font-style/index.md), val caption2: [FontStyle](-font-style/index.md))<br>Typography system for our Components. |
| [FontStyle](-font-style/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>data class [FontStyle](-font-style/index.md)(val size: [TextUnit](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/TextUnit.html) = 14.sp, val weight: [FontWeight](https://developer.android.com/reference/kotlin/androidx/compose/ui/text/font/FontWeight.html) = FontWeight.Normal, val family: [FontFamily](https://developer.android.com/reference/kotlin/androidx/compose/ui/text/font/FontFamily.html) = FontFamily.Default, val textAlign: [TextAlign](https://developer.android.com/reference/kotlin/androidx/compose/ui/text/style/TextAlign.html) = TextAlign.Unspecified)<br>A Font &quot;style&quot; that drives our [Fonts](-fonts/index.md) |
| [GridDimensionSet](-grid-dimension-set/index.md) | [common]<br>data class [GridDimensionSet](-grid-dimension-set/index.md)(val x1: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x2: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x3: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x4: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x5: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x6: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x7: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x8: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x9: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x10: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x11: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x12: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x13: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x14: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x15: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html), val x16: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html))<br>Grid dimension set for proper UI scaling. |
| [ImageAsset](-image-asset/index.md) | [common]<br>expect class [ImageAsset](-image-asset/index.md)<br>[android]<br>actual typealias [ImageAsset](-image-asset/index.md) = [ImageVector](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/vector/ImageVector.html)<br>Image asset type. [ImageVector](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/vector/ImageVector.html) for Android<br>[ios]<br>actual typealias [ImageAsset](-image-asset/index.md) = UIImage<br>Image asset type. UIImage for iOS |
| [ImageAssetIdentifier](-image-asset-identifier/index.md) | [common]<br>expect class [ImageAssetIdentifier](-image-asset-identifier/index.md)<br>[android]<br>actual typealias [ImageAssetIdentifier](-image-asset-identifier/index.md) = [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Image asset identifier. This is the drawable resource ID on Android.<br>[ios]<br>actual typealias [ImageAssetIdentifier](-image-asset-identifier/index.md) = [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Image asset identifier. This is the string asset name normally used in iOS. |
| [ShapeDefinitions](-shape-definitions/index.md) | [common]<br>data class [ShapeDefinitions](-shape-definitions/index.md)(val small: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) = 6.dp, val medium: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) = 10.dp, val large: [Dp](https://developer.android.com/reference/kotlin/androidx/compose/ui/unit/Dp.html) = 20.dp)<br>Shape definitions for Components. |

## Properties

| Name | Summary |
|---|---|
| [LocalBotStacksAssets](-local-bot-stacks-assets.md) | [common]<br>val [LocalBotStacksAssets](-local-bot-stacks-assets.md): [ProvidableCompositionLocal](https://developer.android.com/reference/kotlin/androidx/compose/runtime/ProvidableCompositionLocal.html)&lt;[Assets](-assets/index.md)&gt; |
| [LocalBotStacksColorScheme](-local-bot-stacks-color-scheme.md) | [common]<br>val [LocalBotStacksColorScheme](-local-bot-stacks-color-scheme.md): [ProvidableCompositionLocal](https://developer.android.com/reference/kotlin/androidx/compose/runtime/ProvidableCompositionLocal.html)&lt;[Colors](-colors/index.md)&gt; |
| [LocalBotStacksDimens](-local-bot-stacks-dimens.md) | [common]<br>val [LocalBotStacksDimens](-local-bot-stacks-dimens.md): [ProvidableCompositionLocal](https://developer.android.com/reference/kotlin/androidx/compose/runtime/ProvidableCompositionLocal.html)&lt;[Dimensions](-dimensions/index.md)&gt; |
| [LocalBotStacksFonts](-local-bot-stacks-fonts.md) | [common]<br>val [LocalBotStacksFonts](-local-bot-stacks-fonts.md): [ProvidableCompositionLocal](https://developer.android.com/reference/kotlin/androidx/compose/runtime/ProvidableCompositionLocal.html)&lt;[Fonts](-fonts/index.md)&gt; |
| [staticGridPreset](static-grid-preset.md) | [common]<br>val [staticGridPreset](static-grid-preset.md): [GridDimensionSet](-grid-dimension-set/index.md)<br>Default grid system used for Components. We use a 4pt grid. |

## Functions

| Name | Summary |
|---|---|
| [botstacksFonts](botstacks-fonts.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [botstacksFonts](botstacks-fonts.md)(h1: [FontStyle](-font-style/index.md) = defaultAppFonts().h1, h2: [FontStyle](-font-style/index.md) = defaultAppFonts().h2, h3: [FontStyle](-font-style/index.md) = defaultAppFonts().h3, body1: [FontStyle](-font-style/index.md) = defaultAppFonts().body1, body2: [FontStyle](-font-style/index.md) = defaultAppFonts().body2, label1: [FontStyle](-font-style/index.md) = defaultAppFonts().label1, label2: [FontStyle](-font-style/index.md) = defaultAppFonts().label2, button1: [FontStyle](-font-style/index.md) = defaultAppFonts().button1, button2: [FontStyle](-font-style/index.md) = defaultAppFonts().button2, caption1: [FontStyle](-font-style/index.md) = defaultAppFonts().caption1, caption2: [FontStyle](-font-style/index.md) = defaultAppFonts().caption2): [Fonts](-fonts/index.md) |
| [darkBotStacksColors](dark-bot-stacks-colors.md) | [common]<br>fun [darkBotStacksColors](dark-bot-stacks-colors.md)(primary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.primary._700, onPrimary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._900, header: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._900, onHeader: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._900, background: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._800, onBackground: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._600, surface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._900, onSurface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._900, onSurfaceVariant: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._100, border: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._400, message: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._500, onMessage: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._900, chatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._500, onChatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._600, caption: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._100, success: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.green._700, onSuccess: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._400, error: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.red._700, onError: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = Color(0xFF29292D), ripple: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._500, scrim: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = Color(0x4B4D5866)): [Colors](-colors/index.md)<br>Default &quot;dark&quot; color scheme |
| [lightBotStacksColors](light-bot-stacks-colors.md) | [common]<br>fun [lightBotStacksColors](light-bot-stacks-colors.md)(primary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.primary._800, onPrimary: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._900, header: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.primary._100, onHeader: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._900, background: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._900, onBackground: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._600, surface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._500, onSurface: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._900, onSurfaceVariant: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._100, border: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._500, message: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._700, onMessage: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._900, chatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._600, onChatInput: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._900, caption: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._100, success: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.green._800, onSuccess: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._400, error: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.red._800, onError: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.light._900, ripple: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacksColorPalette.dark._100, scrim: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = Color(0x30313A3B)): [Colors](-colors/index.md)<br>Default &quot;Light&quot; color scheme. |
